(*-------------------------------------------------------------------------------------*)
(*                                                                                     *)
(*               Unit: Childwin                                                        *)
(*                                                                                     *)
(*               Copyright McCallum Whyman Associates Ltd 1996                         *)
(*                                                                                     *)
(*               Version 1.0                                                           *)
(*                                                                                     *)
(*               Author: Tony Whyman                                                   *)
(*                                                                                     *)
(*               Description: This module is part of the J-Write example application   *)
(*                            and defines the TMDIChild class.                         *)
(*-------------------------------------------------------------------------------------*)

unit Childwin;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus,
  FileView, Dialogs;

type
  TMDIChild = class(TForm)
    MainMenu1: TMainMenu;
    FileEditor1: TFileEditor;
    Search1: TMenuItem;
    Find1: TMenuItem;
    FindNext1: TMenuItem;
    Replace1: TMenuItem;
    Edit1: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    Paste1: TMenuItem;
    GotoLine1: TMenuItem;
    Options1: TMenuItem;
    Font1: TMenuItem;
    File1: TMenuItem;
    N1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    Close1: TMenuItem;
    N2: TMenuItem;
    Print1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    N3: TMenuItem;
    Exit1: TMenuItem;
    Undo1: TMenuItem;
    N4: TMenuItem;
    FindDialog1: TFindDialog;
    FontDialog1: TFontDialog;
    Redo1: TMenuItem;
    SaveDialog1: TSaveDialog;
    PrintDialog1: TPrintDialog;
    N5: TMenuItem;
    FlowText1: TMenuItem;
    Capitalise1: TMenuItem;
    N6: TMenuItem;
    InsertPageBreak1: TMenuItem;
    InsertDateTime1: TMenuItem;
    ReplaceDialog1: TReplaceDialog;
    Colour1: TMenuItem;
    ColorDialog1: TColorDialog;
    N7: TMenuItem;
    SelectAll1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Find2: TMenuItem;
    N8: TMenuItem;
    Cut2: TMenuItem;
    Copy2: TMenuItem;
    Paste2: TMenuItem;
    N9: TMenuItem;
    FlowText2: TMenuItem;
    MaxLineLength1: TMenuItem;
    PrintSetup1: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Undo1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure Redo1Click(Sender: TObject);
    procedure FindNext1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure FileEditor1NewFileName(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure FileEditor1SaveModified(Sender: TObject;
      var SaveRequest: TModalResult);
    procedure FileEditor1SaveModePrompt(Sender: TObject;
      var Mode: TSaveMode);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Print1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FlowText1Click(Sender: TObject);
    procedure Capitalise1Click(Sender: TObject);
    procedure InsertPageBreak1Click(Sender: TObject);
    procedure InsertDateTime1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure ReplaceDialog1Find(Sender: TObject);
    procedure Colour1Click(Sender: TObject);
    procedure GotoLine1Click(Sender: TObject);
    procedure FileEditor1StateChange(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure FileEditor1ProgressEvent(Sender: TLinesViewer; Done,
      Total: Longint; var Cancel: Boolean);
    procedure FileEditor1Enter(Sender: TObject);
    procedure FileEditor1Exit(Sender: TObject);
    procedure FileEditor1CaretMoved(Sender: TObject);
    procedure FileEditor1WrapModeChange(Sender: TObject);
    procedure MaxLineLength1Click(Sender: TObject);
    procedure FileEditor1ReplaceAll(Sender: TObject; Count: Integer);
    procedure FileEditor1AbortRequest(Sender: TLinesViewer;
      var Response: Word);
    procedure PrintSetup1Click(Sender: TObject);
  private
    { Private declarations }
    LastState: TViewerStates;
  public
    { Public declarations }
  end;

implementation

Uses main, Printers, SysUtils;

{$R *.DFM}


procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TMDIChild.Undo1Click(Sender: TObject);
begin
     FileEditor1.Undo
end;

procedure TMDIChild.Cut1Click(Sender: TObject);
begin
     FileEditor1.CutToClipBoard
end;

procedure TMDIChild.Copy1Click(Sender: TObject);
begin
     FileEditor1.CopyToClipboard
end;

procedure TMDIChild.Paste1Click(Sender: TObject);
begin
     FileEditor1.PasteFromClipBoard
end;

procedure TMDIChild.Find1Click(Sender: TObject);
begin
     FindDialog1.FindText := FileEditor1.GetInitialFindStr;
     FindDialog1.Execute
end;

procedure TMDIChild.FindDialog1Find(Sender: TObject);
begin
     With Sender As TFindDialog Do
        If not FileEditor1.Find(TFindDialog(Sender),FindText,Options) Then
           MessageDlg('Text not Found',mtError,[mbOK],0)

end;

procedure TMDIChild.Font1Click(Sender: TObject);
begin
     With FontDialog1 Do
     Begin
          Font := FileEditor1.Font;
          If Execute Then
             FileEditor1.Font := Font
     End
end;

procedure TMDIChild.Redo1Click(Sender: TObject);
begin
     FileEditor1.Redo
end;

procedure TMDIChild.FindNext1Click(Sender: TObject);
begin
     FileEditor1.FindNext(nil)
end;

procedure TMDIChild.Close1Click(Sender: TObject);
begin
     Close
end;

procedure TMDIChild.New1Click(Sender: TObject);
begin
     mainform.FileNewItemClick(Sender)
end;

procedure TMDIChild.Open1Click(Sender: TObject);
begin
     MainForm.FileOpenItemClick(Sender)
end;

procedure TMDIChild.FileEditor1NewFileName(Sender: TObject);
begin
     Caption := FileEditor1.FileName
end;

procedure TMDIChild.Save1Click(Sender: TObject);
begin
     FileEditor1.Save
end;

procedure TMDIChild.SaveAs1Click(Sender: TObject);
begin
     With SaveDialog1 Do
     If Execute Then
        FileEditor1.SaveAs(FileName)
end;

procedure TMDIChild.FileEditor1SaveModified(Sender: TObject;
  var SaveRequest: TModalResult);
begin
     SaveRequest := MessageDlg(Caption + ' has been Modified, Save File?',
                         mtConfirmation,mbYesNoCancel,0)
end;

procedure TMDIChild.FileEditor1SaveModePrompt(Sender: TObject;
  var Mode: TSaveMode);
begin
     If FileEditor1.WrapMode = opNone Then
        Mode := smParagraph
     Else
     If Mode = smPrompt Then
     Case MessageDlg('Convert soft Line Breaks to hard Line Breaks?',mtConfirmation,[mbYes,MBNo],0) Of
     mrYes:     Mode := smLineBreaks;
     mrNo:      Mode := smParagraph;
     End

end;

procedure TMDIChild.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     FileEditor1.Clear;
     CanClose := not (vsModified in FileEditor1.State)
end;

procedure TMDIChild.Print1Click(Sender: TObject);

var Wrap: boolean;
    I: integer;

begin
   With PrintDialog1 Do
   If Execute Then
   Begin
     If Printer.Handle = 0 Then
     Begin
          MessageDlg('Printer not setup',mtError,[mbOK],0);
          Exit
     End;

     {Determine Wrap Mode}
     If FileEditor1.WrapMode <> opPrinter Then
        Case MessageDlg('Wrap text to printer width?',mtConfirmation,mbYesNoCancel,0) Of
        mrCancel: Exit;
        mrYes:    Wrap := true;
        mrNo:     Wrap := false;
        End
     Else
         Wrap := true;

     {Print required number of copies}

     For I := 1 To Copies Do
            FileEditor1.Print(Caption,Caption,true,Wrap,PrintRange,FromPage,ToPage)
     End
end;

procedure TMDIChild.Exit1Click(Sender: TObject);
begin
     MainForm.Close
end;

procedure TMDIChild.FlowText1Click(Sender: TObject);
begin
     FileEditor1.FlowText
end;

procedure TMDIChild.Capitalise1Click(Sender: TObject);
begin
     FileEditor1.Capitalise
end;

procedure TMDIChild.InsertPageBreak1Click(Sender: TObject);
begin
     FileEditor1.InsertChar(#12)
end;

procedure TMDIChild.InsertDateTime1Click(Sender: TObject);
begin
     FileEditor1.InsertDateTime(Now)
end;

procedure TMDIChild.Replace1Click(Sender: TObject);
begin
     ReplaceDialog1.FindText := FileEditor1.GetInitialFindStr;
     ReplaceDialog1.Execute

end;

procedure TMDIChild.ReplaceDialog1Find(Sender: TObject);
begin
     With Sender As TReplaceDialog Do
          If not FileEditor1.Replace(TFindDialog(Sender),FindText,ReplaceText,Options) Then
             MessageDlg('Text not found',mtError,[mbOK],0)

end;

procedure TMDIChild.Colour1Click(Sender: TObject);
begin
     With ColorDialog1 Do
     Begin
          Color := FileEditor1.Color;
          If Execute Then
             FileEditor1.Color := Color
     End
end;

procedure TMDIChild.GotoLine1Click(Sender: TObject);

var S: String;
    N: longint;
    Code: integer;
begin
   Str(FileEditor1.LineNumber,S);
   Repeat
     If InputQuery('Goto Line Number','Enter Line Number',S) Then
     Begin
        Val(S,N,Code);
        If Code <> 0 Then
           MessageDlg('A number must be entered here',mtError,[mbYes],0)
        Else
            FileEditor1.LineNumber := N
     End
     Else
         Break
   Until Code = 0

end;

procedure TMDIChild.FileEditor1StateChange(Sender: TObject);

var NotEmpty: boolean;
    TextSelected: boolean;
    PasteAvailable: boolean;
    State: TViewerStates;

begin
     If (Sender is TTextViewer) And TTextViewer(Sender).Focused Then
        State := TTextViewer(Sender).State
     Else
        State := [];

     If LastState <> State Then
     With MainForm Do
     Begin
          If (vsBusy in State) And not (vsBusy in LastState) Then
          Begin
               If not (ProgressMeter1.Visible) Then
               Begin
                    ProgressMeter1.Visible := true;
                    ProgressMeter1.PercentDone := 0;
                    StatusPanel.Caption := 'Press Esc to Cancel'
               End
          End
          Else
          Begin
          If not (vsBusy in State) And (vsBusy in LastState) Then
          Begin
               If ProgressMeter1.Visible Then
               Begin
                    ProgressMeter1.Visible := false;
                    StatusPanel.Caption := Application.Hint;
               End;
          End;
          TextSelected := vsSelection in State;
          NotEmpty := not (vsEmpty in State);
          PasteAvailable := vsPasteAvailable in State;

          PrintBtn.Enabled := NotEmpty;
          CutBtn.Enabled := TextSelected;
          CopyBtn.Enabled := TextSelected;
          PasteBtn.Enabled := PasteAvailable;
          Print1.Enabled := NotEmpty;
          Save1.Enabled := NotEmpty;
          SelectAll1.Enabled := NotEmpty;
          FlowText1.Enabled := NotEmpty;
          FlowText2.Enabled := NotEmpty;
          Find1.Enabled := NotEmpty;
          Find2.Enabled := NotEmpty;
          FindNext1.Enabled := NotEmpty And (vsSearchString in State);
          Replace1.Enabled := NotEmpty;
          GotoLine1.Enabled := NotEmpty;
          Undo1.Enabled := vsUndoAvailable in State;
          Redo1.Enabled := vsRedoAvailable in State;
          Cut1.Enabled := TextSelected;
          Cut2.Enabled := TextSelected;
          Copy1.Enabled := TextSelected;
          Copy2.Enabled := TextSelected;
          Paste1.Enabled := PasteAvailable;
          Paste2.Enabled := PasteAvailable;
          If vsModified in State Then
          Begin
               Save1.Enabled := true;
               ModifiedPanel.Caption := 'Modified'
          End
          Else
          Begin
               Save1.Enabled := false;
               ModifiedPanel.Caption := ''
          End;
          If vsInsertOn in State Then
             InsertPanel.Caption := 'Insert'
          Else
              InsertPanel.Caption := 'Overwrite';
              SaveBtn.Enabled := Save1.Enabled;
          End;
          LastState := State;
     End;
end;

procedure TMDIChild.SelectAll1Click(Sender: TObject);
begin
     FileEditor1.SelectAll
end;

procedure TMDIChild.FileEditor1ProgressEvent(Sender: TLinesViewer; Done,
  Total: Longint; var Cancel: Boolean);
begin
     MainForm.ProgressMeter1.PercentDone := trunc(100 * (Done / Total))
end;

procedure TMDIChild.FileEditor1Enter(Sender: TObject);
begin
     Application.OnIdle := FileEditor1.HandleOnIdle;
     MainForm.WrapNoneBtn.Enabled := true;
     MainForm.WrapScreenBtn.Enabled := true;
     MainForm.WrapPrinterBtn.Enabled := true;
     MainForm.WrapAbsBtn.Enabled := true;
     MainForm.WrapNoneBtn.Down := true;
     MainForm.WrapScreenBtn.Down := true;
     FileEditor1WrapModeChange(Sender);
end;

procedure TMDIChild.FileEditor1Exit(Sender: TObject);
begin
     Application.OnIdle := nil;
     MainForm.WrapNoneBtn.Enabled := false;
     MainForm.WrapScreenBtn.Enabled := false;
     MainForm.WrapPrinterBtn.Enabled := false;
     MainForm.WrapAbsBtn.Enabled := false;
     MainForm.LineCounter.Caption := '';
     MainForm.InsertPanel.Caption := ''
end;

procedure TMDIChild.FileEditor1CaretMoved(Sender: TObject);
begin
     With FileEditor1, MainForm Do
     If Not (vsEmpty in State) Then
     Begin
          If EstimatedLineNumber Then
             LineCounter.Caption := Format('Line ??? Char %d',[CharNumber])
          Else
              LineCounter.Caption := Format('Line %d Char %d',[LineNumber+1,CharNumber])
     End
     Else
         LineCounter.Caption := ''

end;

procedure TMDIChild.FileEditor1WrapModeChange(Sender: TObject);
begin
     With MainFOrm Do
          Case FileEditor1.WrapMode Of
          opNone:
            WrapNoneBtn.Down := true;
          opAbsoluteWrap:
            WrapAbsBtn.Down := true;
          opPrinter:
            WrapPrinterBtn.Down := true;
          opWrapScreenWidth:
            WrapScreenBtn.Down := true;
          End
end;

procedure TMDIChild.MaxLineLength1Click(Sender: TObject);

var S: String;
    N: longint;
    Code: integer;
begin
   Str(FileEditor1.MaxLineLength,S);
   Repeat
     If InputQuery('Set Maximum Line Length','Enter Max. Line Length',S) Then
     Begin
        Val(S,N,Code);
        If Code <> 0 Then
           MessageDlg('A number must be entered here',mtError,[mbYes],0)
        Else
            FileEditor1.MaxLineLength := N
     End
     Else
         Break
   Until Code = 0
end;

procedure TMDIChild.FileEditor1ReplaceAll(Sender: TObject; Count: Integer);
begin
     MessageBeep(MB_OK);
     MessageDlg(Format('%d items replaced',[Count]),mtInformation,[mbOK],0)
end;

procedure TMDIChild.FileEditor1AbortRequest(Sender: TLinesViewer;
  var Response: Word);
begin
     Response := MessageDlg('Abort Action?',mtConfirmation,[mbYes,mbNo],0)
end;

procedure TMDIChild.PrintSetup1Click(Sender: TObject);
begin
     MainForm.PrintSetup1Click(Sender)
end;

end.
